document.addEventListener("DOMContentLoaded", function () {
  const startTime = new Date();

  document.addEventListener("click", function (event) {
    const pageUrl = window.location.href;
    const ipAddress = "";
    const eventData = {
      timeSpent: Math.round((new Date() - startTime) / 1000),
    };
    sendEventData(
      "click",
      event.target.innerText,
      pageUrl,
      ipAddress,
      eventData
    );
  });

  const pageUrl = window.location.href;
  const ipAddress = "";
  const eventData = {
    timeSpent: Math.round((new Date() - startTime) / 1000),
  };
  sendEventData("visit", "", pageUrl, ipAddress, eventData);
});

function sendEventData(eventType, targetText, pageUrl, ipAddress, eventData) {
  const xhr = new XMLHttpRequest();
  // xhr.open("POST", "https://plctaxservices.com/track", true);
  xhr.open("POST", "https://tmadash.com/track", true);
  xhr.setRequestHeader("Content-Type", "application/json");
  const timestamp = new Date().toISOString().slice(0, 19).replace("T", " ");
  const data = {
    event: eventType,
    target: targetText,
    timestamp: timestamp,
    pageUrl: pageUrl,
    ipAddress: ipAddress,
    timeSpent: eventData.timeSpent,
  };

  xhr.send(JSON.stringify(data));
}
